<?php
header('Content-Type: application/json; charset=utf-8');

$plik = 'text.json';

// jeśli plik nie istnieje, utwórz pusty JSON
if (!file_exists($plik)) {
    file_put_contents($plik, '{}');
}

// pobierz wiadomość z POST
$message = $_POST['message'] ?? '';

if ($message === '') {
    echo json_encode(['status' => 'error', 'msg' => 'Brak wiadomości']);
    exit;
}

// wczytaj istniejący plik JSON
$stany = json_decode(file_get_contents($plik), true);
if (!is_array($stany)) $stany = [];

// zapisujemy wiadomość
$stany['message'] = $message;

// zapis do pliku
file_put_contents($plik, json_encode($stany, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

echo json_encode(['status' => 'ok']);
?>
